FasdUAS 1.101.10        
  k           
  l           b\ 	Scripting with Merlin Project

	You may incorporate this ProjectWizards sample code into your program(s) without
	restriction.  This ProjectWizards sample code has been provided "AS IS" and the
	responsibility for its operation is yours.  You are not permitted to
	redistribute this ProjectWizards sample code as "ProjectWizards sample code" after having
	made changes.  If you're going to redistribute the code, we require
	that you make it clear that the code was descended from ProjectWizards sample
	code, but that you've made changes.

	Copyright 2023 ProjectWizards, Melle, Germany. All rights reserved.
	
	This script 
	1- collects all activities of a current project, 
	2- exports in a adoc text file on the Desktop
	3- and converts the adoc text file in a pdf (using asciidoctor-pdf)
	 
	For export: 
	 currently following props exported: expected start, expected end, expected duration, assigned to 
	 outline level places the items in their hierchy in the document (=) 
	 it should export the attachments 
	 grouped by kind 
	
	
	Version info: 1.0
	Author: Vicky Stamatopoulou
	Date: Dec 2022
	Info: PDF creation of all items and their attachments for documentation reasons  
	
	Version info: 2.0
	 better pdf creation (title page with cover, title, subtitle and revision Date)
	 each scheduled item on its own page
	- data from the scheduled item in a table:
	 Title
	 Subtitle
	 Additional Title
	 Expected Start / End
	 Expected Duration
	 Expected Work
	 Expected Costs
	 Complete
	 Group Path
	 Resources
	 Successors
	 Tags
	 Notes
	x Comments
	
	 Notes per scheduled item and attachment 
	
	Version info: 2.5
	Data from the attachments in a table:
	 Title
	 Subtitle
	 Additional Title
	 Status 
	 Tags
	 Notes
	
	 info: url
	 checklist: checklist items
	 file: name
	 issue: assigned to / fixed until
	 risk: probability / in charge
	
	Version info: 2.6
	Date: Jan 2023
	Resources (fonts, themes and image for the title page) are now in the pathToThemeResources property 
	and the theme has relative paths so it can find the fonts and image for the title page there
	
	Version info: 2.6.1
	Output only those rows which have values (making a smaller and better readable file)
	
	Version info: 2.6.2
	Solved limitations occurring when the script runs from the Actions menu
	 When outputting durations use the Merlin Project locals instead of constant ****Week, constant ****Week, etc => localized string of unit
	When outputting status use the Merlin Project locals instead of constant **Futu, etc => create and use a statusConversion value list
	
	Above limitations did not affect the script when running directly from ScriptEditor.
	
	Version info: 2.6.3
	The pathToThemeResources is automatically calculated to read the home directory
	
	Version info: 2.6.4
	Special title handling for Milestones and output of this information in the table

	
      	 	   	 S c r i p t i n g   w i t h   M e r l i n   P r o j e c t 
 
 	 Y o u   m a y   i n c o r p o r a t e   t h i s   P r o j e c t W i z a r d s   s a m p l e   c o d e   i n t o   y o u r   p r o g r a m ( s )   w i t h o u t 
 	 r e s t r i c t i o n .     T h i s   P r o j e c t W i z a r d s   s a m p l e   c o d e   h a s   b e e n   p r o v i d e d   " A S   I S "   a n d   t h e 
 	 r e s p o n s i b i l i t y   f o r   i t s   o p e r a t i o n   i s   y o u r s .     Y o u   a r e   n o t   p e r m i t t e d   t o 
 	 r e d i s t r i b u t e   t h i s   P r o j e c t W i z a r d s   s a m p l e   c o d e   a s   " P r o j e c t W i z a r d s   s a m p l e   c o d e "   a f t e r   h a v i n g 
 	 m a d e   c h a n g e s .     I f   y o u ' r e   g o i n g   t o   r e d i s t r i b u t e   t h e   c o d e ,   w e   r e q u i r e 
 	 t h a t   y o u   m a k e   i t   c l e a r   t h a t   t h e   c o d e   w a s   d e s c e n d e d   f r o m   P r o j e c t W i z a r d s   s a m p l e 
 	 c o d e ,   b u t   t h a t   y o u ' v e   m a d e   c h a n g e s . 
 
 	 C o p y r i g h t    2 0 2 3   P r o j e c t W i z a r d s ,   M e l l e ,   G e r m a n y .   A l l   r i g h t s   r e s e r v e d . 
 	 
 	 T h i s   s c r i p t   
 	 1 -   c o l l e c t s   a l l   a c t i v i t i e s   o f   a   c u r r e n t   p r o j e c t ,   
 	 2 -   e x p o r t s   i n   a   a d o c   t e x t   f i l e   o n   t h e   D e s k t o p 
 	 3 -   a n d   c o n v e r t s   t h e   a d o c   t e x t   f i l e   i n   a   p d f   ( u s i n g   a s c i i d o c t o r - p d f ) 
 	   
 	 F o r   e x p o r t :   
 	"   c u r r e n t l y   f o l l o w i n g   p r o p s   e x p o r t e d :   e x p e c t e d   s t a r t ,   e x p e c t e d   e n d ,   e x p e c t e d   d u r a t i o n ,   a s s i g n e d   t o   
 	"   o u t l i n e   l e v e l   p l a c e s   t h e   i t e m s   i n   t h e i r   h i e r c h y   i n   t h e   d o c u m e n t   ( = )   
 	"   i t   s h o u l d   e x p o r t   t h e   a t t a c h m e n t s   
 	"   g r o u p e d   b y   k i n d   
 	 
 	 
 	 V e r s i o n   i n f o :   1 . 0 
 	 A u t h o r :   V i c k y   S t a m a t o p o u l o u 
 	 D a t e :   D e c   2 0 2 2 
 	 I n f o :   P D F   c r e a t i o n   o f   a l l   i t e m s   a n d   t h e i r   a t t a c h m e n t s   f o r   d o c u m e n t a t i o n   r e a s o n s     
 	 
 	 V e r s i o n   i n f o :   2 . 0 
 	"   b e t t e r   p d f   c r e a t i o n   ( t i t l e   p a g e   w i t h   c o v e r ,   t i t l e ,   s u b t i t l e   a n d   r e v i s i o n   D a t e ) 
 	"   e a c h   s c h e d u l e d   i t e m   o n   i t s   o w n   p a g e 
 	 -   d a t a   f r o m   t h e   s c h e d u l e d   i t e m   i n   a   t a b l e : 
 	"   T i t l e 
 	"   S u b t i t l e 
 	"   A d d i t i o n a l   T i t l e 
 	"   E x p e c t e d   S t a r t   /   E n d 
 	"   E x p e c t e d   D u r a t i o n 
 	"   E x p e c t e d   W o r k 
 	"   E x p e c t e d   C o s t s 
 	"   C o m p l e t e 
 	"   G r o u p   P a t h 
 	"   R e s o u r c e s 
 	"   S u c c e s s o r s 
 	"   T a g s 
 	"   N o t e s 
 	 x   C o m m e n t s 
 	 
 	"   N o t e s   p e r   s c h e d u l e d   i t e m   a n d   a t t a c h m e n t   
 	 
 	 V e r s i o n   i n f o :   2 . 5 
 	 D a t a   f r o m   t h e   a t t a c h m e n t s   i n   a   t a b l e : 
 	"   T i t l e 
 	"   S u b t i t l e 
 	"   A d d i t i o n a l   T i t l e 
 	"   S t a t u s   
 	"   T a g s 
 	"   N o t e s 
 	 
 	"   i n f o :   u r l 
 	"   c h e c k l i s t :   c h e c k l i s t   i t e m s 
 	"   f i l e :   n a m e 
 	"   i s s u e :   a s s i g n e d   t o   /   f i x e d   u n t i l 
 	"   r i s k :   p r o b a b i l i t y   /   i n   c h a r g e 
 	 
 	 V e r s i o n   i n f o :   2 . 6 
 	 D a t e :   J a n   2 0 2 3 
 	 R e s o u r c e s   ( f o n t s ,   t h e m e s   a n d   i m a g e   f o r   t h e   t i t l e   p a g e )   a r e   n o w   i n   t h e   p a t h T o T h e m e R e s o u r c e s   p r o p e r t y   
 	 a n d   t h e   t h e m e   h a s   r e l a t i v e   p a t h s   s o   i t   c a n   f i n d   t h e   f o n t s   a n d   i m a g e   f o r   t h e   t i t l e   p a g e   t h e r e 
 	 
 	 V e r s i o n   i n f o :   2 . 6 . 1 
 	 O u t p u t   o n l y   t h o s e   r o w s   w h i c h   h a v e   v a l u e s   ( m a k i n g   a   s m a l l e r   a n d   b e t t e r   r e a d a b l e   f i l e ) 
 	 
 	 V e r s i o n   i n f o :   2 . 6 . 2 
 	 S o l v e d   l i m i t a t i o n s   o c c u r r i n g   w h e n   t h e   s c r i p t   r u n s   f r o m   t h e   A c t i o n s   m e n u 
 	"   W h e n   o u t p u t t i n g   d u r a t i o n s   u s e   t h e   M e r l i n   P r o j e c t   l o c a l s   i n s t e a d   o f    c o n s t a n t   * * * * W e e k  ,    c o n s t a n t   * * * * W e e k  ,   e t c   = >   l o c a l i z e d   s t r i n g   o f   u n i t & 
 	"  W h e n   o u t p u t t i n g   s t a t u s   u s e   t h e   M e r l i n   P r o j e c t   l o c a l s   i n s t e a d   o f    c o n s t a n t   * * F u t u  ,   e t c   = >   c r e a t e   a n d   u s e   a   s t a t u s C o n v e r s i o n   v a l u e   l i s t 
 	 
 	 A b o v e   l i m i t a t i o n s   d i d   n o t   a f f e c t   t h e   s c r i p t   w h e n   r u n n i n g   d i r e c t l y   f r o m   S c r i p t E d i t o r . 
 	 
 	 V e r s i o n   i n f o :   2 . 6 . 3 
 	 T h e   p a t h T o T h e m e R e s o u r c e s   i s   a u t o m a t i c a l l y   c a l c u l a t e d   t o   r e a d   t h e   h o m e   d i r e c t o r y 
 	 
 	 V e r s i o n   i n f o :   2 . 6 . 4 
 	 S p e c i a l   t i t l e   h a n d l i n g   f o r   M i l e s t o n e s   a n d   o u t p u t   o f   t h i s   i n f o r m a t i o n   i n   t h e   t a b l e 
 
 	 
   
 
 
 l               

  j       0 newline newLine
  m            
 
   
  j      0 documentname documentName
  m            P r o j e c t   H a n d b o o k    
  l        
  j      ,0 pathtoasciidoctorpdf pathToAsciidoctorPDF
  m           / u s r / l o c a l / b i n /  z tcould be "/usr/local/bin/" or something else just call 'which asciidoctor-pdf' in the terminal to determine the path         c o u l d   b e   " / u s r / l o c a l / b i n / "   o r   s o m e t h i n g   e l s e   j u s t   c a l l   ' w h i c h   a s c i i d o c t o r - p d f '   i n   t h e   t e r m i n a l   t o   d e t e r m i n e   t h e   p a t h     
  j   	  ! &0 foldertoresources folderToResources
 ! m   	 
 " "  # #  r e s - f o r - s c r i p t    $ %
 $ j     & 0 	themename 	themeName
 & m    
 ' '  ( ( 6 r e p o r t - f o r - p d f - r e l a t i v e p a t h %  ) *
 ) j    J + $0 statusconversion statusConversion
 + J    I , ,  - .
 - K     / /  0 1
 
pnam
 0 m     2 2  3 3  U n s c h e d u l e d 1  4 	0 const  
 4 m     5 5  6 6  U n s c   .  7 8
 7 K     9 9  : ;
 
pnam
 : m     < <  = =  F u t u r e ;  > 	0 const  
 > m     ? ?  @ @  F u t u   8  A B
 A K    ' C C  D E
 
pnam
 D m    ! F F  G G  O n   t i m e E  H 	0 const  
 H m   " % I I  J J  O n T i   B  K L
 K K   ' 1 M M  N O
 
pnam
 N m   ( + P P  Q Q 0 S l i g h t l y   b e h i n d   s c h e d u l e O  R 	0 const  
 R m   , / S S  T T  S B S c   L  U V
 U K   1 ; W W  X Y
 
pnam
 X m   2 5 Z Z  [ [  B e h i n d   s c h e d u l e Y  \ 	0 const  
 \ m   6 9 ] ]  ^ ^  B e S c   V  _
 _ K   ; E ` `  a b
 
pnam
 a m   < ? c c  d d  C o m p l e t e b  e 	0 const  
 e m   @ C f f  g g  C o m p     *  h i
 h l            i  j k
 j i   K N l m
 l I     
 .aevtoappnull      ****    
 m k     f n n  o p
 o p       q q  0 twolines twoLines   p  r s
 r r     
 t u
 t b      v w
 v o      0 newline newLine
 w o    
 0 newline newLine
 u o       0 twolines twoLines s  x y
 x w    d z {
 z k    d | |  } ~
 } l          ~   
  r      
  I     &0 collectactivities collectActivities    
  o       0 
lstactivities 
lstActivities   
  Z    d  
  >     
  o     0 
lstactivities 
lstActivities
  J      
  k    `     
  l             
  r    @  
  n    *  
  I     *  0 
createfile 
createFile   
  n     &  
  1   $ &
 
Titl
  n     $  
  4   ! $ 
 
cobj
  m   " # 
  o     ! 0 
lstactivities 
lstActivities    
   f     
  J           
  o        0 thetextfileref theTextFileRef    
  o       0 pos     
  o       0 	afilename 	aFileName      
  l  A A          
  I   A H  &0 processactivities processActivities    
  o   B C 0 
lstactivities 
lstActivities   
  o   C D  0 thetextfileref theTextFileRef        
  l  I I          
  l  I I      Q K no furher conversion parameters because they are included in the adoc file           n o   f u r h e r   c o n v e r s i o n   p a r a m e t e r s   b e c a u s e   t h e y   a r e   i n c l u d e d   i n   t h e   a d o c   f i l e    
  I  I ^ 
 .sysoexecTEXT     TEXT
  b   I Z  
  b   I X  
  b   I V  
  b   I T  
  b   I P  
  o   I N ,0 pathtoasciidoctorpdf pathToAsciidoctorPDF
  m   N O        a s c i i d o c t o r - p d f  
  n   P S  
  1   Q S
 
psxp
  o   P Q 0 pos  
  m   T U       '
  o   V W 0 	afilename 	aFileName
  m   X Y       '     
  l  _ _               {                                                                                      @ alis    B  Macintosh HD                   BD Merlin Project.app                                                           
 cu             Applications  "/:Applications:Merlin Project.app/  &  M e r l i n   P r o j e c t . a p p    M a c i n t o s h   H D  Applications/Merlin Project.app   /    y  
  l  e e         k   
  l               
  i   O R  
  I        0 	roundthis 	roundThis    
  o       0 n     
  o       0 numdecimals numDecimals    
  k          
  r       
  a       
  m      

  o     0 numdecimals numDecimals
  o       0 x     
  O     
  L     
  ^      
  l    
  \      
  _      
   g    

  m   
    ?      
  _      
   g    
  m         
  o     0 x  
  ]    	  
  o     0 n  
  o     0 x        
  l               
  i   S V  
  I        0 
createfile 
createFile   
  o       0 	afilename 	aFileName    
  k         
  l           "  creates the file on Desktop        8   c r e a t e s   t h e   f i l e   o n   D e s k t o p    
  l           K E returns a handler for the TextFile and its position on the hard disk           r e t u r n s   a   h a n d l e r   f o r   t h e   T e x t F i l e   a n d   i t s   p o s i t i o n   o n   t h e   h a r d   d i s k    
  r       
  m            
  o       0 
thetextref 
theTextRef    
  r     
  I   	
 .earsffdralis        afdr
 m    
 afdrdesk  
 o       0 pos    
 r    
 c    
 o    
 0 pos  
 m   
 
 
TEXT
 o       0 pos   	

	 l   ~}  ~  }  
 
 r    3


 l     |{
 I     zyx
z .misccurdldt     nully  x  |  {  
 K     w
w 
year
 o    vv 0 y   u
u 
mnth
 o    tt 0 m   sr
s 
day 
 o    qq 0 d  r   
 r   4 =
 c   4 ;
 l  4 9po
 b   4 9
 b   4 7 
 o   4 5nn 0 m  
  m   5 6!! ""   
 o   7 8mm 0 y  p  o  
 m   9 :l
l 
TEXT
 o      kk 	0 today   #$
# l  > >jihj  i  h  $ %&
% r   > G'(
' l  > E)gf
) n   > E*+
* 1   C Ee
e 
time
+ l  > C,dc
, I  > Cba`
b .misccurdldt     nulla  `  d  c  g  f  
( o      __ 0 mytime myTime& -.
- l  H H^]\^  ]  \  . /0
/ r   H Y12
1 b   H W34
3 b   H S56
5 b   H Q78
7 b   H M9:
9 b   H K;<
; o   H I[[ 	0 today  
< m   I J== >>  -
: o   K LZZ 0 mytime myTime
8 m   M P?? @@  -
6 o   Q RYY 0 	afilename 	aFileName
4 m   S VAA BB 
 . a d o c
2 o      XX &0 qualifiedfilename qualifiedFileName0 CD
C l  Z ZWVUW  V  U  D EF
E l  Z ZTSRT  S  R  F GH
G O   ZIJ
I k   `KK LM
L p   ` `NN QPQ 0 twolines twoLinesP  M OP
O r   ` sQR
Q n   ` qST
S 1   m qO
O 
psxp
T l  ` mUNM
U I  ` mLVW
L .earsffdralis        afdr
V m   ` cK
K afdrcusrW JXI
J 
rtyp
X m   f iH
H 
ctxtI  N  M  
R o      GG ,0 pathtothemeresources pathToThemeResourcesP YZ
Y l  t tFEDF  E  D  Z [\
[ Z   t]^CB
] H   t |_
_ l  t {`A@
` I  t {?a>
? .coredoexnull     obj 
a b   t wbc
b o   t u== 0 pos  
c o   u v<< 0 	afilename 	aFileName>  A  @  
^ k   
dd ef
e r    gh
g b    ij
i o    ;; 0 pos  
j o    :: &0 qualifiedfilename qualifiedFileName
h o      99 60 qualifiedfilenamewithpath qualifiedFileNameWithPathf kl
k r    mn
m I   8op
8 .rdwropenshor       file
o 4    7q
7 
file
q o    66 60 qualifiedfilenamewithpath qualifiedFileNameWithPathp 5r4
5 
perm
r m    3
3 boovtrue4  
n o      22  0 thetextfileref theTextFileRefl st
s l   10/1  0  /  t uv
u I   .wx
. .rdwrseofnull     ****
w o    --  0 thetextfileref theTextFileRefx ,y+
, 
set2
y m    **  +  v z{
z l   )|})  | ' ! insert a header to the adoc file   } ~~ B   i n s e r t   a   h e a d e r   t o   t h e   a d o c   f i l e{ 
 r    
 b    
 b    
 b    
 b    
 b    
 b    
 b    
 b    
 b    
 b    
 b    
 b    
 b    
 b    
 b    
 b    
 b    
 m      L : a u t h o r 2 :   b y   M e r l i n   P r o j e c t 
 : r e v d a t e :  
 o    (( 	0 today  
 m       
 : t i t l e - p a g e :
 m       
 =  
 o    '' 0 	afilename 	aFileName
 m       :  
 o    && 0 documentname documentName
 m      ^ 
 : t o c l e v e l s :   5 
 : t o c 2 : 
 : i c o n s :   f o n t 
 : p d f - t h e m e :  
 o    %% 0 	themename 	themeName
 o    $$ 0 newline newLine
 l 	  #"
 m       : p d f - f o n t s d i r :  #  "  
 o    !! ,0 pathtothemeresources pathToThemeResources
 o       &0 foldertoresources folderToResources
 m      . / f o n t s 
 : p d f - t h e m e s d i r :  
 o     ,0 pathtothemeresources pathToThemeResources
 o     &0 foldertoresources folderToResources
 m       / t h e m e s
 o     0 twolines twoLines
 o       0 
outputtext 
outputText 
 l          
 I  
 .rdwrwritnull     ****
 o     0 
outputtext 
outputText 
 
refn
 o      0 thetextfileref theTextFileRef 
 
wrat
 m    
 rdwreof  
 
as  
 m    
 
utf8   
 l    6 0 beep to let know that the adoc file was created     `   b e e p   t o   l e t   k n o w   t h a t   t h e   a d o c   f i l e   w a s   c r e a t e d 
 l    
 beep      b e e p 
 l 

       
 L  
 J   
 o  

  0 thetextfileref theTextFileRef 
 o  		 0 pos   
 o   &0 qualifiedfilename qualifiedFileName   
 l 		        C  B  \ 
 L  
 m  
 boovfals  
J m   Z ]                                                                                  MACS  alis    @  Macintosh HD                   BD 
Finder.app                                                                   
 cu             CoreServices  )/:System:Library:CoreServices:Finder.app/    
 F i n d e r . a p p    M a c i n t o s h   H D  &System/Library/CoreServices/Finder.app  /   H  
 l            
 l            
 i   W Z
 I       0 writecontent writeContent 
 o       0 what   
 o       0 	whichfile 	whichFile    
 k      
 l            
 I    
 .rdwrwritnull     ****
 o      0 what   
 
refn
 o     0 	whichfile 	whichFile 
 
wrat
 m    
 rdwreof  
 
as  
 m    
 
utf8   
 l          
 L    
 m    
      
 l            
 l            
 i   [ ^
 I       &0 collectactivities collectActivities    
 k     -  
  r     
 J       
 o       0 
allactivities 
allActivities 
 l          
 Q    (	

 O   
 r    


 n    
 2   
 
CAct
 n    
 1    
 
RoPr
 4   
 
docu
 m     
 o       0 
allactivities 
allActivities
 m    	                                                                                      @ alis    B  Macintosh HD                   BD Merlin Project.app                                                           
 cu             Applications  "/:Applications:Merlin Project.app/  &  M e r l i n   P r o j e c t . a p p    M a c i n t o s h   H D  Applications/Merlin Project.app   /   
	 R      
 .ascrerr ****       ****    

 I   (
 .sysodlogaskr        TEXT
 m        N o t h i n g   t o   d o !   ( P l e a s e   o p e n   a   p r o j e c t   a n d   c a l l   t h e   s c r i p t   a g a i n . 
 
btns
 J   ! $ 
 m   ! "   O k     
 l  ) )        !
  L   ) +"
" o   ) * 0 
allactivities 
allActivities! #
# l  , ,         $%
$ l           % &'
& i   _ b()
( I      * ,0 outputattachmentlist outputAttachmentList* +,
+ o       0 alist aList, -.
- o       0 aname aName. /0
/ o       0 alevel aLevel0 12
1 o       0 proj  2 3
3 o       0 
decoration      
) k    44 56
5 l           6 78
7 p      99  0 twolines twoLines  8 :;
: w    <=
< k   >> ?@
? r    AB
A m    CC DD  
B o       0 atext aText@ E
E Z   FG
F >   
HI
H o     0 alist aList
I J    	  
G k   
JJ KL
K Y   
 #MNO
M r    PQ
P b    RS
R o     0 atext aText
S m    TT UU  =
Q o       0 atext aText 0 i  
N m     
O [    VW
V o     0 alevel aLevel
W m       L XY
X r   $ /Z[
Z b   $ -\]
\ b   $ +^_
^ b   $ )`a
` b   $ 'bc
b o   $ % 0 atext aText
c m   % &dd ee  = =  
a o   ' ( 0 aname aName
_ o   ) * 0 
decoration  
] o   + , 0 twolines twoLines
[ o       0 atext aTextY f
f X   0gh
g k   @ii jk
j l  @ @      k lm
l r   @ Gno
n n   @ Epq
p 5   A Er
 
Atta
r o   B C 0 b  
 kfrmID  
q o   @ A 0 proj  
o o       0 theitem theItemm st
s l  H H      t uv
u r   H Uwx
w b   H Syz
y b   H Q{|
{ b   H O}~
} b   H K
 o   H I 0 atext aText
 m   I J   *
~ n   K N
 1   L N
 
Titl
 o   K L 0 theitem theItem
| m   O P   *
z o   Q R 0 twolines twoLines
x o       0 atext aTextv 
 l  V V       
 r   V ]
 b   V [
 b   V Y
 o   V W 0 atext aText
 m   W X  " [ c o l s = " 1 , 2 " ] 
 | = = =
 o   Y Z 0 twolines twoLines
 o       0 atext aText 
 r   ^ a
 m   ^ _
 
msng
 o       0 astatus aStatus 
 Q   b u
 r   e l
 n   e j
 1   h j
 
Titl
 n   e h
 m   f h
 
Stat
 o   e f 0 theitem theItem
 o       0 astatus aStatus
 R      
 .ascrerr ****       ****       
 l  v v~}|~  }  |   
 Q   v {
 r   y 
 n   y ~
 1   z ~z
z 
RiSt
 o   y zyy 0 theitem theItem
 o      xx 0 astatus aStatus
 R      wvu
w .ascrerr ****       ****v  u  {   
 l   tsrt  s  r   
 Q    q
 r    
 n    
 1    p
p 
Chkd
 o    oo 0 theitem theItem
 o      nn 0 astatus aStatus
 R      mlk
m .ascrerr ****       ****l  k  q   
 l   jihj  i  h   
 l   gfeg  f  e   
 O    
 k     
 r    
 b    
 o    dd 0 atext aText
 n    
 I    cbc :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m       S u b t i t l e 
 1    a
a 
SuTi `
 m    _
_ boovfals`  b  
  f    
 o      ^^ 0 atext aText ]
 r    
 b    
 o    \\ 0 atext aText
 n    
 I    [Z[ :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m        A d d i t i o n a l   T i t l e 
 1    Y
Y 
AdTi X
 m    W
W boovfalsX  Z  
  f    
 o      VV 0 atext aText]  
 o    UU 0 theitem theItem 
 r    
 b    
 o    TT 0 atext aText
 n    
 I    SRS :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m       S t a t u s 
 o    QQ 0 astatus aStatus P
 m    O
O boovfalsP  R  
  f    
 o      NN 0 atext aText 
 l   MLKM  L  K   
 Q   _J
 k   V 
 l   II     for checklist        f o r   c h e c k l i s t 
 r    
 n    
 1    H
H 
Titl
 n     
 2   G
G 
ChIt
  o    FF 0 theitem theItem
 o      EE 0 	itemnames 	itemNames 
 r    
 n    
 1    D
D 
Chkd
 n    
 2   C
C 
ChIt
 o    BB 0 theitem theItem
 o      AA 0 itemchecked itemChecked 	

	 l   @?>@  ?  >  
 
 r   


 b   
 b   
 b    
 o    == 0 atext aText
 n    
 I    <;< 0 
cellwithvalue 
cellWithValue :
 m       C h e c k l i s t   i t e m s:  ;  
  f    
 o    99 0 newline newLine
 m     a |
 o      88 0 atext aText 
 l 7657  6  5    
 Y  L!4"#3
! k  G$$ %&
% r  '(
' m  )) **  -  
( o      22 0 temp  & +,
+ r  $-.
- b  "/0
/ o  11 0 temp  
0 n  !12
1 4  !03
0 
cobj
3 o   // 0 c  
2 o  .. 0 	itemnames 	itemNames
. o      -- 0 temp  , 45
4 l %%,+*,  +  *  5 67
6 Z %989)(
8 = %+:;
: n  %)<=
< 4  &)'>
' 
cobj
> o  '(&& 0 c  
= o  %&%% 0 itemchecked itemChecked
; m  )*$
$ boovtrue
9 r  .5?@
? b  .3AB
A o  ./## 0 temp  
B m  /2CC DD    [ x ]
@ o      "" 0 temp  )  (  7 EF
E r  :EGH
G b  :CIJ
I b  :=KL
K o  :;!! 0 atext aText
L o  ;<   0 temp  
J o  =B 0 newline newLine
H o       0 atext aTextF M
M l FF        4 0 c  
" m   
# I N
 .corecnte****       ****
N o  
 0 	itemnames 	itemNames  3    O
O r  MVPQ
P b  MTRS
R o  MN 0 atext aText
S o  NS 0 newline newLine
Q o       0 atext aText  
 R      
 .ascrerr ****       ****    J   TU
T l ``
  
    U VW
V l ``
	  
  	  W XY
X Z  `~Z[\
Z l `e]
] E  `e^_
^ o  `a 0 aname aName
_ m  ad`` aa  I s s u e s    
[ k  hbb cd
c Q  hef
e r  kgh
g b  k}ij
i o  kl 0 atext aText
j n  l|kl
k I  m|m :0 rowwithpropertynameandvalue rowWithPropertyNameAndValuem no
n m  mppp qq  A s s i g n e d   t oo rs
r n  pwtu
t 1  uw 
  
Titl
u n  puvw
v 1  qu
 
AsTo
w o  pq 0 theitem theItems x
x m  wx
 boovfals    
l  f  lm
h o       0 atext aText
f R      
 .ascrerr ****       ****      d yz
y l       z {|
{ r  }~
} b  
 o   0 atext aText
 n  
 I   :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m     F i x   u n t i l 
 n  
 1  
 
FiUn
 o   0 theitem theItem 
 m  
 boovfals    
  f  
~ o       0 atext aText| 
 l         \ 
 l 
 E  
 o   0 aname aName
 m    
 R i s k s     
 k   
 l        
 r  
 b  
 o   0 atext aText
 n  
 I   :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m      R i s k   D e s c r i p t i o n 
 n  
 1  
 
RiDe
 o   0 theitem theItem 
 m  
 boovfals    
  f  
 o       0 atext aText 
 Q  
 r  
 b  
 o   0 atext aText
 n  
 I   :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m     I n   C h a r g e 
 n  
 1  
 
Titl
 n  
 1  
 
InCh
 o   0 theitem theItem 
 m  
 boovfals    
  f  
 o       0 atext aText
 R      
 .ascrerr ****       ****       
 Q  
 r  
 b  
 o   0 atext aText
 n  
 I   :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m     P r o b a b i l i t y 
 n  
 1  
 
Prob
 o   0 theitem theItem 
 m  
 boovfals    
  f  
 o       0 atext aText
 R      
 .ascrerr ****       ****       
 l        
 l          
 l 
 E  
 o    0 aname aName
 m     
 I n f o s     
 k   
 l        
 r  
 b  
 o   0 atext aText
 n  
 I  	 :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m  	   U R L 
 n  
 1  

 
Url 
 o  
 0 theitem theItem 
 m  
 boovfals    
  f  	
 o       0 atext aText 
 l          
 l #
 E  #
 o   0 aname aName
 m  "  
 F i l e s      
 k  &H 
 l &&       
 Q  &H
 k  )? 	
 l ))
  
 2 , fails when there is no info about the media     X   f a i l s   w h e n   t h e r e   i s   n o   i n f o   a b o u t   t h e   m e d i a	 


 r  )?
 b  )=
 o  )* 0 atext aText
 n  *<
 I  +< :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m  +.  
 M e d i a 
 n  .7
 1  37
 
pnam
 n  .3
 1  /3
 
Medi
 o  ./ 0 theitem theItem 
 m  78
 boovfals    
  f  *+
 o       0 atext aText  
 R      
 .ascrerr ****       ****           !
  l KP"
" E  KP#$
# o  KL 0 aname aName
$ m  LO%% &&  E v e n t s    ! '
' k  Sz(( )*
) r  Se+,
+ b  Sc-.
- o  ST 0 atext aText
. n  Tb/0
/ I  Ub1 :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue1 23
2 m  UX44 55  S t a r t   d a t e3 67
6 n  X]89
8 1  Y]
 
StDa
9 o  XY 0 theitem theItem7 :
: m  ]^
 boovfals    
0  f  TU
, o       0 atext aText* ;<
; r  fx=>
= b  fv?@
? o  fg 0 atext aText
@ n  guAB
A I  huC :0 rowwithpropertynameandvalue rowWithPropertyNameAndValueC DE
D m  hkFF GG  U R LE HI
H n  kpJK
J 1  lp
 
Url 
K o  kl 0 theitem theItemI L
L m  pq
 boovfals    
B  f  gh
> o       0 atext aText< M~
M l yy}|{}  |  {  ~      Y NO
N l zyxz  y  x  O PQ
P O  RS
R k  TT UV
U l wvuw  v  u  V WX
W Q  YZt
Y k  [[ \]
\ r  ^_
^ J  ss  
_ o      rr 0 tagitems tagItems] `a
` r  bc
b n  de
d 1  q
q 
Titl
e 2 p
p 
OTag
c o      oo 0 tagitems tagItemsa fn
f Z ghml
g > ij
i o  kk 0 tagitems tagItems
j J  jj  
h r  kl
k b  mn
m o  ii 0 atext aText
n n  op
o I  hqgh :0 rowwithpropertynameandvalue rowWithPropertyNameAndValueq rs
r m  tt uu  T a g ss vw
v n  xy
x I  fzef *0 convertlisttostring convertlistTostringz {|
{ o  dd 0 tagitems tagItems| }c
} m  ~~   ,  c  e  
y  f  w b
 m  a
a boovfalsb  g  
p  f  
l o      `` 0 atext aTextm  l  n  
Z R      _^]
_ .ascrerr ****       ****^  ]  t  X 
 l \[Z\  [  Z   Y
 Z XW
 > 
 1  V
V 
Nots
 m     
 r  
 b  
 o  UU 0 atext aText
 n  
 I  TST :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m    
 N o t e s 
 1  R
R 
Nots Q
 m  P
P boovfalsQ  S  
  f  
 o      OO 0 atext aTextX  W  Y  
S o  NN 0 theitem theItemQ 
 l MLKM  L  K   
 r  
 b  
 b  
 o  JJ 0 atext aText
 m     | = = =
 o  II 0 twolines twoLines
 o      HH 0 atext aText G
 l FEDF  E  D  G   0 b  
h o   3 4CC 0 alist aList        =                                                                                      @ alis    B  Macintosh HD                   BD Merlin Project.app                                                           
 cu             Applications  "/:Applications:Merlin Project.app/  &  M e r l i n   P r o j e c t . a p p    M a c i n t o s h   H D  Applications/Merlin Project.app   /   ; 
 L  
 o  BB 0 atext aText A
 l @?>@  ?  >  A  ' 
 l     =<;=  <  ;   
 i   c f
 I      :9: 0 
withdisclamer 
withDisclamer 8
 o      77  0 thetextfileref theTextFileRef8  9  
 k      
 l     6546  5  4   
 l     3213  2  1   
 r     
 m      H = =   P r o j e c t   D o c u m e n t a t i o n   D i s c l a m e r 
 
 T h i s   d o c u m e n t a t i o n   w a s   a u t o m a t i c a l l y   c r e a t e d   h t t p s : / / p r o j e c t w i z a r d s . n e t / m e r l i n - p r o j e c t [ { a u t h o r 2 } ]   i n   p a s s : a t t r i b u t e s [ { r e v d a t e } ] .
 o      00 0 
outputtext 
outputText 
 l   /.-/  .  -   
 I   ,
, .rdwrwritnull     ****
 o    ++ 0 
outputtext 
outputText *
* 
refn
 o    ))  0 thetextfileref theTextFileRef (
( 
wrat
 m    	'
' rdwreof  &%
& 
as  
 m   
 $
$ 
utf8%   
 L    ##   "
 l   ! !       "   
 l            
 i   g j
 I       :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 o       0 	aproperty 	aProperty 
 o       0 avalue aValue 
 o       0 
decoration      
 k     ? 
 p        0 twolines twoLines   
 Z     =
 l    
 >    
 o      0 avalue aValue
 m    
 
msng    
 k    8 
 Z    6
 =   	
 o    

 0 
decoration  
 m    
 boovfals
 L    
 b    
 b    
 I    
 0 
cellwithvalue 
cellWithValue 	
 o   
  0 	aproperty 	aProperty	  
  
 I     0 
cellwithvalue 
cellWithValue 
 o     0 avalue aValue    
 o     0 twolines twoLines  
 L    6
 b    5
 b    3
 b    +
 I    % 0 
cellwithvalue 
cellWithValue  
 o     ! 0 	aproperty 	aProperty     
 o   % * 0 newline newLine
 I   + 2 :0 cellwithvaluewithdecoration cellWithValueWithDecoration 
 o   , - 0 avalue aValue 
 o   - . 0 
decoration      
 o   3 4 0 twolines twoLines  
  l  7 7          
 L   ; =   
 l  > >         
 l            
 i   k n
 I       0 
cellwithvalue 
cellWithValue 	
	 o       0 atext aText    
 k     

 
 l            


 Z     
 >    
 o      0 atext aText
 m    
 
msng
 L    

 b    	
 m       |
 o     0 atext aText  
 L   
 
 m   
    | 
 l            
 l             
 i   o r!"
! I      # :0 cellwithvaluewithdecoration cellWithValueWithDecoration# $%
$ o       0 atext aText% &
& o       0 
decoration      
" k     '' ()
( l           ) *+
* Z     ,-.
, >    /0
/ o      0 atext aText
0 m    
 
msng
- k    11 23
2 L    4
4 b    
56
5 b    78
7 b    	9:
9 m    ;; <<  |
: o     0 atext aText
8 m   	 
== >>   
6 o     0 
decoration  3 ?
? l             
. L    @
@ m    AA BB  |+ C
C l             DE
D l           E FG
F l           G HI
H l           I JK
J i   s vLM
L I      N *0 convertlisttostring convertlistTostringN OP
O o       0 thelist theListP Q
Q o       0 thedelimiter theDelimiter    
M k     RR ST
S r     UV
U o      0 thedelimiter theDelimiter
V n     WX
W 1    
 
txdl
X 1    
 
ascrT YZ
Y r    [\
[ c    	]^
] o     0 thelist theList
^ m    
 
TEXT
\ o       0 	thestring 	theStringZ _`
_ r    ab
a m    
cc dd  
b n     ef
e 1    
 
txdl
f 1   
 
 
ascr` g
g L    h
h o     0 	thestring 	theString  K ij
i l           j kl
k i   w zmn
m I      o >0 mapstatusconstanttostatusname mapStatusConstantToStatusNameo p
p o       0 aitem aItem    
n k     ?qq rs
r Y     <tuv
t k    7ww xy
x l   z{  z d ^display dialog (const of item i of statusConversion) & "-" & (localized string of aItem) & "."   { ||  d i s p l a y   d i a l o g   ( c o n s t   o f   i t e m   i   o f   s t a t u s C o n v e r s i o n )   &   " - "   &   ( l o c a l i z e d   s t r i n g   o f   a I t e m )   &   " . "y }
} Z    7~
~ l   "
 =   "
 l   
 I   
 .sysolocSutxt        TEXT
 o     0 aitem aItem      
 n    !
 o    ! 	0 const  
 n    
 4    
 
cobj
 o     0 i  
 o     $0 statusconversion statusConversion    
 k   % 3 
 r   % 1
 n   % /
 1   - /
 
pnam
 n   % -
 4   * -
 
cobj
 o   + , 0 i  
 o   % * $0 statusconversion statusConversion
 o       0 aitem aItem 
 l  2 2    display dialog aItem     ( d i s p l a y   d i a l o g   a I t e m 
  S   2 3         0 i  
u m     
v I   

 .corecnte****       ****
 o    	 $0 statusconversion statusConversion    s 
 L   = ?
 o   = > 0 aitem aItem  l 
 l            
 i   { ~
 I       &0 processactivities processActivities 
 o       0 
allactivities 
allActivities 
 o        0 thetextfileref theTextFileRef    
 k     
 p       ~ 0 twolines twoLines~   
 l     }|{}  |  {   
 l     zyxz  y  x   
 O    
 k    
 I   	wvu
w .miscactvnull  nullv  u   
 r   
 
 n   
 
 1    t
t 
RoPr
 4  
 s
s 
docu
 m    
rr 
 o      qq 0 proj   
 r    
 n    
 1    p
p 
CSym
 n    
 1    o
o 
RoPr
 4   n
n 
docu
 m    mm 
 o      ll 0 projcurrency projCurrency 
 l   kjik  j  i   
 r    !
 m       
 o      hh 0 
outputtext 
outputText 
 X   "Xg
 k   2S 
 r   2 7
 n   2 5
 m   3 5f
f 
Stat
 o   2 3ee 0 act  
 o      dd 0 astatus aStatus 
 r   8 @
 n   8 >
 I   9 >cbc >0 mapstatusconstanttostatusname mapStatusConstantToStatusName a
 o   9 :`` 0 astatus aStatusa  b  
  f   8 9
 o      __ 0 astatus aStatus 
 O   Ag
 k   Ef 
 l  E E^]\^  ]  \   
 r   E N
 n   E L
 1   J L[
[ 
Titl
 n   E J
 2  H JZ
Z 
Reso
 2  E HY
Y 
Assi
 o      XX 0 
aresources 
aResources 
 r   O T
 2  O RW
W 
Atta
 o      VV 0 
attacheditems 
attachedItems 
 r   U \
 n   U Z
 1   X ZU
U 
Titl
 2  U XT
T 
OTag
 o      SS 0 tagitems tagItems 
 Q   ] pR
 r   ` g
 2  ` eQ
Q 
NeDp
 o      PP "0 dependencyitems dependencyItems
 R      ONM
O .ascrerr ****       ****N  M  R    
  r   q 
 J   q  
 1   q tL
L 
Titl 
 1   t yK
K 
AdTi 	

	 1   y ~J
J 
SuTi
 I
 1   ~ H
H 
NotsI  
 J       


 o      GG 0 mytitle   
 o      FF $0 aadditionaltitle aAdditionalTitle 
 o      EE 0 asub aSub D
 o      CC 0 anote aNoteD   
 r    
 J     
 1    B
B 
OtLv 
 1    A
A 
FlOr 
 1    @
@ 
path ?
 1    >
> 
MiSt?  
 J         !"
! o      == 0 alevel aLevel" #$
# o      << 0 aorder aOrder$ %&
% o      ;; 0 apath aPath& ':
' o      99 
0 ams aMS:   ()
( r   $*+
* J    ,, -.
- 1    8
8 
ExSt. /0
/ 1    7
7 
ExEn0 12
1 1    6
6 
PlSt2 35
3 1    4
4 
PlEn5  
+ J      44 56
5 o      33 0 astart aStart6 78
7 o      22 0 aend aEnd8 9:
9 o      11 0 plannedstart plannedStart: ;0
; o      // 0 
plannedend 
plannedEnd0  ) <=
< r  %D>?
> J  %1@@ AB
A 1  %*.
. 
ExDuB C-
C 1  */,
, 
ExWo-  
? J      DD EF
E o      ++ 0 	aduration 	aDurationF G*
G o      )) 0 awork aWork*  = HI
H r  EdJK
J J  EQLL MN
M 1  EJ(
( 
AcCpN O'
O 1  JO&
& 
ExCs'  
K J      PP QR
Q o      %% 0 	acomplete 	aCompleteR S$
S o      ## 0 acost aCost$  I T"
T l ee! !       "  
 o   A B 0 act   UV
U l hh      V WX
W l hh      X YZ
Y r  hu[\
[ n  hq]^
] I  iq_ *0 convertlisttostring convertlistTostring_ `a
` o  ij 0 
aresources 
aResourcesa b
b m  jmcc dd  ,      
^  f  hi
\ o       0 atitles aTitlesZ ef
e l vv      f gh
g r  v|ij
i J  vx  
j o       "0 successortitles successorTitlesh kl
k X  }m
n
m O  op
o Q  qr
q k  ss tu
t l vw  v !  get title of next activity   w xx 6   g e t   t i t l e   o f   n e x t   a c t i v i t yu y

y r  z{
z b  |}
| o  		 "0 successortitles successorTitles
} n  ~
~ 1  
 
Titl
 1  
 
NxAc
{ o       "0 successortitles successorTitles
  
r R      
 .ascrerr ****       ****      
p o   0 j  
 0 j  
n o   "0 dependencyitems dependencyItemsl 
 l          
 l        
 l    [ Uif tagItems is not {} then set tagTitles to convertlistTostring(tagItems, ", ") of me      i f   t a g I t e m s   i s   n o t   { }   t h e n   s e t   t a g T i t l e s   t o   c o n v e r t l i s t T o s t r i n g ( t a g I t e m s ,   " ,   " )   o f   m e 
 l        
 l        
 Z  
 =  
 o   0 aorder aOrder
 m    
 k   
 l    ( " Item Zero: Handler to the project     D   I t e m   Z e r o :   H a n d l e r   t o   t h e   p r o j e c t 
 l    0 * add the first title and the project stamp     T   a d d   t h e   f i r s t   t i t l e   a n d   t h e   p r o j e c t   s t a m p 
 l        
 l 
 r  
 b  
 b  
 b  
 b  
 m     < < <
 o   0 newline newLine
 m     = =  
 o   0 mytitle  
 o   0 twolines twoLines
 o       0 
outputtext 
outputText . ( add the first title into the outputText     P   a d d   t h e   f i r s t   t i t l e   i n t o   t h e   o u t p u t T e x t 
 l        
 l      creating a project stamp     2   c r e a t i n g   a   p r o j e c t   s t a m p 
 r  
 b  
 b  
 o   0 
outputtext 
outputText
 m    " [ c o l s = " 1 , 2 " ] 
 | = = =
 o   0 twolines twoLines
 o       0 
outputtext 
outputText 
 l        
 r  
 b  
 o   0 
outputtext 
outputText
 n  
 I   :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m    * * P l a n n e d   ( S t a r t - E n d ) * 
 b  
 b  
 n  
 1  
 
shdt
 n  
 1  
 
TmSt
 o   0 plannedstart plannedStart
 m       -  
 n  
 1  
 
shdt
 n  
 1  
 
TmSt
 o   0 
plannedend 
plannedEnd 
 m   
 boovfals    
  f  
 o       0 
outputtext 
outputText 
 l        
 r  0
 b  .
 o  	 0 
outputtext 
outputText
 n  	-
 I  
- :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m  

  , * E x p e c t e d   ( S t a r t - E n d ) * 
 b  
(
 b  

 n  

 1  
 
shdt
 n  

 1  
 
TmSt
 o  
 0 astart aStart
 m         -  
 n  '
 1  #'
 
shdt
 n  #
 1  #
 
TmSt
 o   0 aend aEnd 
 m  ()
 boovfals    
  f  	

 o       0 
outputtext 
outputText 
 l 11       	
 Z  1c


 > 18

 o  14 0 	acomplete 	aComplete

 m  47
 
msng
 k  ;_ 
 r  ;L
 n  ;H
 I  <H 0 	roundthis 	roundThis 
 ]  <C
 o  <? 0 	acomplete 	aComplete
 m  ?B d 
 m  CD     
  f  ;<
 o       0 	acomplete 	aComplete 
 l MM       
 r  M_
 b  M] !
  o  MN 0 
outputtext 
outputText
! n  N\"#
" I  O\$ :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue$ %&
% m  OR'' ((  * D o n e *& )*
) o  RU 0 	acomplete 	aComplete* +
+ m  UX,, --  %    
#  f  NO
 o       0 
outputtext 
outputText      	 ./
. l dd      / 01
0 l dd      1 23
2 l dd      3 45
4 Z d67
6 > di89
8 o  de 0 anote aNote
9 m  eh
 
msng
7 r  l{:;
: b  ly<=
< b  ls>?
> b  lq@A
@ o  lm 0 
outputtext 
outputText
A m  mpBB CC  | * O b j e c t i v e * 
 a |
? o  qr 0 anote aNote
= o  sx 0 newline newLine
; o       0 
outputtext 
outputText    5 DE
D l       E FG
F l       G HI
H r  JK
J b  LM
L b  NO
N b  PQ
P o   0 
outputtext 
outputText
Q o   0 newline newLine
O m  RR SS  | = = =
M o   0 twolines twoLines
K o       0 
outputtext 
outputTextI TU
T l       U VW
V r  XY
X n  Z[
Z I  \ 0 writecontent writeContent\ ]^
] o   0 
outputtext 
outputText^ _
_ o    0 thetextfileref theTextFileRef    
[  f  
Y o       0 
outputtext 
outputTextW `
` l           
 k  aa bc
b l       c de
d r  fg
f b  hi
h b  jk
j o   0 
outputtext 
outputText
k m  ll mm  < < <
i o  ~~ 0 newline newLine
g o      }} 0 
outputtext 
outputTexte no
n Y  p|qr{
p r  st
s b  uv
u o  zz 0 
outputtext 
outputText
v m  ww xx  =
t o      yy 0 
outputtext 
outputText| 0 i  
q m  xx 
r [  yz
y o  ww 0 alevel aLevel
z m  vv {  o {|
{ l utsu  t  s  | }~
} r  
 m     
 o      rr 0 
decoration  ~ 
 Z qp
 l on
 = 
 o  mm 
0 ams aMS
 m  l
l boovtrueo  n  
 r  
 m     M S :  
 o      kk 0 
decoration  q  p   
 l 
 r  
 b  
 b  
 b  
 b  
 o  jj 0 
outputtext 
outputText
 m      
 o  ii 0 
decoration  
 o  hh 0 mytitle  
 o  gg 0 twolines twoLines
 o      ff 0 
outputtext 
outputText . ( add the titles of new items on new rows     P   a d d   t h e   t i t l e s   o f   n e w   i t e m s   o n   n e w   r o w s 
 l ee   , & creating an activity properties table     L   c r e a t i n g   a n   a c t i v i t y   p r o p e r t i e s   t a b l e 
 r   
 b  
 b  
 o  dd 0 
outputtext 
outputText
 m    " [ c o l s = " 1 , 2 " ] 
 | = = =
 o  cc 0 twolines twoLines
 o      bb 0 
outputtext 
outputText 
 l a`_a  `  _   
 r  
 b  

 o  ^^ 0 
outputtext 
outputText
 n  
 I  ]\] :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m     S u b t i t l e 
 o  [[ 0 asub aSub Z
 m  Y
Y boovfalsZ  \  
  f  
 o      XX 0 
outputtext 
outputText 
 l WVUW  V  U   
 r  
 b  
 o  TT 0 
outputtext 
outputText
 n  
 I  SRS :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m      A d d i t i o n a l   T i t l e 
 o  QQ $0 aadditionaltitle aAdditionalTitle P
 m  O
O boovfalsP  R  
  f  
 o      NN 0 
outputtext 
outputText 
 l MLKM  L  K   
 r  /
 b  -
 o   JJ 0 
outputtext 
outputText
 n   ,
 I  !,IHI :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m  !$   G r o u p   P a t h 
 o  $'GG 0 apath aPath F
 m  '(E
E boovfalsF  H  
  f   !
 o      DD 0 
outputtext 
outputText 
 Z 0LCB
 l 05A@
 = 05
 o  03?? 
0 ams aMS
 m  34>
> boovtrueA  @  
 r  8H
 b  8F
 o  89== 0 
outputtext 
outputText
 n  9E
 I  :E<;< :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m  :=   M i l e s t o n e 
 m  =@  ' :
 m  @A9
9 boovfals:  ;  
  f  9:
 o      88 0 
outputtext 
outputTextC  B   
 r  Mu
 b  Ms 
  o  MN77 0 
outputtext 
outputText
 n  Nr
 I  Or656 :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m  OR  ( E x p e c t e d   ( S t a r t - E n d ) 	

	 b  Rm
 b  Ra


 l R]43
 n  R]
 1  Y]2
2 
shdt
 n  RY
 1  UY1
1 
TmSt
 o  RU00 0 astart aStart4  3  
 m  ]`     -  
 l al/.
 n  al
 1  hl-
- 
shdt
 n  ah
 1  dh,
, 
TmSt
 o  ad++ 0 aend aEnd/  .  
 *
 m  mn)
) boovfals*  5  
  f  NO
 o      (( 0 
outputtext 
outputText 
 l vv'&%'  &  %   
 Z  v
 !$#
  > v}"#
" o  vy"" 0 	aduration 	aDuration
# m  y|!
! 
msng
! w  	$%
$ k  	&& '(
' l  )*   ) 5 / how do I get the locals and not the constants?   * ++ ^   h o w   d o   I   g e t   t h e   l o c a l s   a n d   n o t   t h e   c o n s t a n t s ?( ,-
, r  ./
. l 0
0 n  12
1 1  
 
Unit
2 o   0 	aduration 	aDuration    
/ o       0 aunit aUnit- 3
3 Z  	456
4 > 78
7 o   0 awork aWork
8 m  
 
msng
5 r  9:
9 b  ;<
; o   0 
outputtext 
outputText
< n  =>
= I  ? :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue? @A
@ m  BB CC 2 E x p e c t e d   W o r k   i n   D u r a t i o nA DE
D b  FG
F b  HI
H b  JK
J b  LM
L b  NO
N b  PQ
P n  RS
R I  T 0 	roundthis 	roundThisT UV
U n  WX
W 1  
 
Amnt
X o   0 awork aWorkV Y
Y m       
S  f  
Q m  ZZ [[   
O l \

\ I ]

 .sysolocSutxt        TEXT
] n  ^_
^ 1  	
	 
Unit
_ o   0 awork aWork
  
    
M m  `` aa    -  
K n  bc
b I  d 0 	roundthis 	roundThisd ef
e n  gh
g 1  
 
Amnt
h o   0 	aduration 	aDurationf i
i m       
c  f  
I m  jj kk   
G l l 
l I m
 .sysolocSutxt        TEXT
m o   0 aunit aUnit       E n
n m  
 boovfals    
>  f  
: o       0 
outputtext 
outputText  
6 r  	op
o b  qr
q o   0 
outputtext 
outputText
r n  st
s I  u :0 rowwithpropertynameandvalue rowWithPropertyNameAndValueu vw
v m  xx yy " E x p e c t e d   D u r a t i o nw z{
z b  |}
| b  ~
~ n  
 I   0 	roundthis 	roundThis 
 n  
 1  
 
Amnt
 o   0 	aduration 	aDuration 
 m       
  f  
 m      
} l  
 I  
 .sysolocSutxt        TEXT
 o   0 aunit aUnit      { 
 m  
 boovfals    
t  f  
p o       0 
outputtext 
outputText  %                                                                                      @ alis    B  Macintosh HD                   BD Merlin Project.app                                                           
 cu             Applications  "/:Applications:Merlin Project.app/  &  M e r l i n   P r o j e c t . a p p    M a c i n t o s h   H D  Applications/Merlin Project.app   /   $  #   
 l        
 r  
 b  
 o   0 
outputtext 
outputText
 n  
 I   :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m     E x p e c t e d   C o s t 
 o   0 acost aCost 
 o   0 projcurrency projCurrency    
  f  
 o       0 
outputtext 
outputText 
 Z  Q
 > &
 o  " 0 	acomplete 	aComplete
 m  "%
 
msng
 k  )M 
 r  ):
 n  )6
 I  *6 0 	roundthis 	roundThis 
 ]  *1
 o  *- 0 	acomplete 	aComplete
 m  -0 d 
 m  12     
  f  )*
 o       0 	acomplete 	aComplete 
 r  ;M
 b  ;K
 o  ;< 0 
outputtext 
outputText
 n  <J
 I  =J :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m  =@  " A c t u a l   C o m p l e t i o n 
 o  @C 0 	acomplete 	aComplete 
 m  CF   %    
  f  <=
 o       0 
outputtext 
outputText       
 l RR       
 l RR       
 r  R`
 b  R^
 o  RS 0 
outputtext 
outputText
 n  S]
 I  T] :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m  TW   S t a t u s 
 o  WX 0 astatus aStatus 
 m  XY
 boovfals    
  f  ST
 o       0 
outputtext 
outputText 
 l aa       
 l aa       
 Z a
 > ag
 o  ad "0 successortitles successorTitles
 J  df  
 r  j
 b  j
 o  jk 0 
outputtext 
outputText
 n  k
 I  l :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue 
 m  lo   S u c c e s s o r s 
 n  oz
 I  pz *0 convertlisttostring convertlistTostring 
 o  ps "0 successortitles successorTitles 
 m  sv   ,      
  f  op 
 m  z{
 boovfals    
  f  kl
 o       0 
outputtext 
outputText     
 l        
 Q  
 k   
 Z 	 	
	  > 		
	 o   0 atitles aTitles
	 m  		 		  
	 r  		
	 b  			
	 o   0 
outputtext 
outputText
		 n  	
	
	
 I  	 :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue	 	
	
	
 m  		 		  A s s i g n e d   t o	 		
	 o   0 atitles aTitles	 	
	 m  
 boovfals    
	  f  
	 o       0 
outputtext 
outputText     	
	 l         
 R      
 .ascrerr ****       ****       		
	 l       	 		
	 l       	 		
	 Z 		
	 > 		
	 o   0 tagitems tagItems
	 J    
	 r  		 
	 b  	!	"
	! o   0 
outputtext 
outputText
	" n  	#	$
	# I  	% :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue	% 	&	'
	& m  	(	( 	)	)  T a g s	' 	*	+
	* n  	,	-
	, I  	. *0 convertlisttostring convertlistTostring	. 	/	0
	/ o   0 tagitems tagItems	0 	1
	1 m  	2	2 	3	3  ,      
	-  f  	+ 	4
	4 m  
 boovfals    
	$  f  
	  o       0 
outputtext 
outputText    	 	5	6
	5 l       	6 	7	8
	7 l ~}  ~  }  	8 	9	:
	9 Z 	;	<|{
	; > 	=	>
	= o  zz 0 anote aNote
	> m  	?	? 	@	@  
	< r  	A	B
	A b  	C	D
	C o  yy 0 
outputtext 
outputText
	D n  	E	F
	E I  x	Gwx :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue	G 	H	I
	H m  	J	J 	K	K 
 N o t e s	I 	L	M
	L o  vv 0 anote aNote	M 	Nu
	N m  t
t boovfalsu  w  
	F  f  
	B o      ss 0 
outputtext 
outputText|  {  	: 	O	P
	O l rqpr  q  p  	P 	Q	R
	Q r  	S	T
	S b  	U	V
	U b  	W	X
	W o  oo 0 
outputtext 
outputText
	X m  	Y	Y 	Z	Z  | = = =
	V o  nn 0 twolines twoLines
	T o      mm 0 
outputtext 
outputText	R 	[	\
	[ l lkjl  k  j  	\ 	]i
	] l hgfh  g  f  i   	^	_
	^ l edce  d  c  	_ 	`	a
	` l b	b	cb  	b #  creating a project stamp END   	c 	d	d :   c r e a t i n g   a   p r o j e c t   s t a m p   E N D	a 	e	f
	e l a`_a  `  _  	f 	g	h
	g l ^	i	j^  	i * $ last property of the scheduled item   	j 	k	k H   l a s t   p r o p e r t y   o f   t h e   s c h e d u l e d   i t e m	h 	l	m
	l l ]\[]  \  [  	m 	n	o
	n Z  3	p	qZY
	p > 	r	s
	r o   XX 0 
attacheditems 
attachedItems
	s J   WW  
	q k  /	t	t 	u	v
	u Y  	wV	x	yU
	w r  	z	{
	z b  	|	}
	| o  TT 0 
outputtext 
outputText
	} m  	~	~ 		  =
	{ o      SS 0 
outputtext 
outputTextV 0 i  
	x m  	
RR 
	y [  

		
	 o  
QQ 0 alevel aLevel
	 m  PP U  	v 		
	 r  2		
	 b  0		
	 b  *		
	 b  $		
	 o   OO 0 
outputtext 
outputText
	 m   #		 		  =   A t t a c h m e n t s  
	 o  $)NN 0 newline newLine
	 o  */MM 0 newline newLine
	 o      LL 0 
outputtext 
outputText	 		
	 l 33KJIK  J  I  	 		
	 r  3		
	 J  3C		 		
	 J  35HH  	 		
	 J  57GG  	 		
	 J  79FF  	 		
	 J  9;EE  	 		
	 J  ;=DD  	 	C
	 J  =?BB  C  
	 J      		 		
	 o      AA 	0 infos  	 		
	 o      @@ 0 evs  	 		
	 o      ?? 0 rsks  	 		
	 o      >> 0 checkss  	 		
	 o      == 
0 filess  	 	<
	 o      ;; 0 issuess  <  	 		
	 l :98:  9  8  	 		
	 X  U	7	
	 k  P		 		
	 r  		
	 n  		
	 1  6
6 
ID  
	 o  55 0 j  
	 o      44 
0 aid aId	 		
	 Z 		32
	 = 		
	 n  		
	 m  1
1 
pcls
	 o  00 0 j  
	 m  /
/ 
Info
	 r  		
	 b  		
	 o  .. 	0 infos  
	 o  -- 
0 aid aId
	 o      ,, 	0 infos  3  2  	 		
	 Z 		+*
	 = 		
	 n  		
	 m  )
) 
pcls
	 o  (( 0 j  
	 m  '
' 
Even
	 r  		
	 b  		
	 o  && 0 evs  
	 o  %% 
0 aid aId
	 o      $$ 0 evs  +  *  	 		
	 Z 		#"
	 = 		
	 n  		
	 m  !
! 
pcls
	 o     0 j  
	 m  
 
Chec
	 r  		
	 b  		
	 o   0 checkss  
	 o   
0 aid aId
	 o       0 checkss  #  "  	 		
	 Z 		
	 = 		
	 n  		
	 m  
 
pcls
	 o   0 j  
	 m  
 
Risk
	 r  		
	 b  		
	 o   0 rsks  
	 o   
0 aid aId
	 o       0 rsks      	 		
	 Z 2		
	 =  		
	 n  		
	 m  
 
pcls
	 o   0 j  
	 m  
 
FiAt
	 r  #.		
	 b  #*		
	 o  #& 
0 filess  
	 o  &)

 
0 aid aId
	 o       
0 filess      	 	
	 Z 3P		
	
	 = 3>		
	 n  3:		
	 m  6:
 
pcls
	 o  36 0 j  
	 m  :=
 
Issu
	 r  AL		
	 b  AH		
	 o  AD 0 issuess  
	 o  DG 
0 aid aId
	 o       0 issuess  
  	    7 0 j  
	 o   0 
attacheditems 
attachedItems	 
 

  l VV        
 


 Z Vy


 > V\


 o  VY 	0 infos  
 J  Y[  
 r  _u

	
 b  _s




 o  _` 0 
outputtext 
outputText
 n  `r



 I  ar
 ,0 outputattachmentlist outputAttachmentList
 


 o  ad 	0 infos  
 


 m  dg

 

  I n f o s  
 


 o  gh 0 alevel aLevel
 


 o  hi 0 proj  
 

 m  il

 

 $ i c o n : i n f o - c i r c l e [ ]    

  f  `a
	 o       0 
outputtext 
outputText    
 


 Z z


 > z
 
!
  o  z} 0 evs  
! J  }  
 r  
"
#
" b  
$
%
$ o   0 
outputtext 
outputText
% n  
&
'
& I  
( ,0 outputattachmentlist outputAttachmentList
( 
)
*
) o   0 evs  
* 
+
,
+ m  
-
- 
.
.  E v e n t s  
, 
/
0
/ o   0 alevel aLevel
0 
1
2
1 o   0 proj  
2 
3
3 m  
4
4 
5
5  i c o n : c a l e n d a r [ ]    
'  f  
# o       0 
outputtext 
outputText    
 
6
7
6 Z 
8
9
8 > 
:
;
: o   
0 filess  
; J    
9 r  
<
=
< b  
>
?
> o   0 
outputtext 
outputText
? n  
@
A
@ I  
B ,0 outputattachmentlist outputAttachmentList
B 
C
D
C o   
0 filess  
D 
E
F
E m  
G
G 
H
H  F i l e s  
F 
I
J
I o   0 alevel aLevel
J 
K
L
K o   0 proj  
L 
M
M m  
N
N 
O
O  i c o n : f i l e [ ]    
A  f  
= o       0 
outputtext 
outputText    
7 
P
Q
P Z 
R
S
R > 
T
U
T o   0 checkss  
U J    
S r  
V
W
V b  
X
Y
X o   0 
outputtext 
outputText
Y n  
Z
[
Z I  
\ ,0 outputattachmentlist outputAttachmentList
\ 
]
^
] o   0 checkss  
^ 
_
`
_ m  
a
a 
b
b  C h e c k l i s t s
` 
c
d
c o   0 alevel aLevel
d 
e
f
e o   0 proj  
f 
g
g m  
h
h 
i
i (   i c o n : c h e c k - c i r c l e [ ]    
[  f  
W o       0 
outputtext 
outputText    
Q 
j
k
j Z 	
l
m
l > 
n
o
n o   0 issuess  
o J    
m r  
p
q
p b  
r
s
r o   0 
outputtext 
outputText
s n  
t
u
t I  
v ,0 outputattachmentlist outputAttachmentList
v 
w
x
w o   0 issuess  
x 
y
z
y m  
{
{ 
|
|  I s s u e s
z 
}
~
} o   0 alevel aLevel
~ 


 o   0 proj  
 

 m  

 

    i c o n : b u g [ ]    
u  f  
q o       0 
outputtext 
outputText    
k 


 Z 
-


 > 



 o  

 0 rsks  
 J  
  
 r  )


 b  '


 o   0 
outputtext 
outputText
 n  &


 I  &
 ,0 outputattachmentlist outputAttachmentList
 


 o   0 rsks  
 


 m  

 

  R i s k s  
 


 o   0 alevel aLevel
 


 o   0 proj  
 

 m   

 

  i c o n : b o m b [ ]    
  f  
 o       0 
outputtext 
outputText    
 

 l ..        Z  Y  	o 


 l 44      
 

 Z  4S


 = 4=


 l 4;

 `  4;


 o  47 0 aorder aOrder
 m  7: K    
 m  ;<  
 k  @O

 


 r  @I


 n  @G


 I  AG
 0 writecontent writeContent
 


 o  AB 0 
outputtext 
outputText
 

 o  BC  0 thetextfileref theTextFileRef    
  f  @A
 o       0 
outputtext 
outputText
 

 I JO
 .sysobeepnull  long            g 0 act  
 o   % & 0 
allactivities 
allActivities 


 l YY      
 


 r  Yb


 n  Y`


 I  Z`
 0 writecontent writeContent
 


 o  Z[ 0 
outputtext 
outputText
 

 o  [\  0 thetextfileref theTextFileRef    
  f  YZ
 o       0 
outputtext 
outputText
 


 n  ci


 I  di
 0 
withdisclamer 
withDisclamer
 

 o  de  0 thetextfileref theTextFileRef    
  f  cd
 


 I jo
 .sysobeepnull  long    
 


 l pp      
 

 Q  p


 I sx

 .rdwrclosnull     ****
 o  st  0 thetextfileref theTextFileRef  
 R      
 .ascrerr ****       ****        
 m     

                                                                                      @ alis    B  Macintosh HD                   BD Merlin Project.app                                                           
 cu             Applications  "/:Applications:Merlin Project.app/  &  M e r l i n   P r o j e c t . a p p    M a c i n t o s h   H D  Applications/Merlin Project.app   /    

 l ~    ~     


 l     }|{}  |  {  
 


 l     zyxz  y  x  
 


 l     wvuw  v  u  
 


 l     tsrt  s  r  
 


 l     qpoq  p  o  
 
n
 l     mlkm  l  k  n       (j
    " '















i

hgfedcba`_^]\[j  
 &ZYXWVUTSRQPONMLKJIHGFEDCBA@?>=<;:98765Z 0 newline newLineY 0 documentname documentNameX ,0 pathtoasciidoctorpdf pathToAsciidoctorPDFW &0 foldertoresources folderToResourcesV 0 	themename 	themeNameU $0 statusconversion statusConversion
T .aevtoappnull      ****S 0 	roundthis 	roundThisR 0 
createfile 
createFileQ 0 writecontent writeContentP &0 collectactivities collectActivitiesO ,0 outputattachmentlist outputAttachmentListN 0 
withdisclamer 
withDisclamerM :0 rowwithpropertynameandvalue rowWithPropertyNameAndValueL 0 
cellwithvalue 
cellWithValueK :0 cellwithvaluewithdecoration cellWithValueWithDecorationJ *0 convertlisttostring convertlistTostringI >0 mapstatusconstanttostatusname mapStatusConstantToStatusNameH &0 processactivities processActivitiesG 0 twolines twoLinesF 0 
lstactivities 
lstActivitiesE  0 thetextfileref theTextFileRefD 0 pos  C 0 	afilename 	aFileNameB  A  @  ?  >  =  <  ;  :  9  8  7  6  5  
 4
4 
  






 3 2

3 
pnam
 2 512 	0 const  1  
 0 <

0 
pnam
 / ?./ 	0 const  .  
 - F

- 
pnam
 , I+, 	0 const  +  
 * P

* 
pnam
 ) S() 	0 const  (  
 ' Z

' 
pnam
 & ]%& 	0 const  %  
 $ c

$ 
pnam
 # f"# 	0 const  "  
 ! m 


! .aevtoappnull      ****     
  
  {    0 twolines twoLines &0 collectactivities collectActivities 0 
lstactivities 
lstActivities
 
cobj
 
Titl 0 
createfile 
createFile  0 thetextfileref theTextFileRef 0 pos   0 	afilename 	aFileName &0 processactivities processActivities
 
psxp
 .sysoexecTEXT     TEXT gb   b   %EOZ*j+ EOjv F)k/,k+ E[k/EZ[l/EZ[m/EZO*l+ 
Ob  %,%%%%j OPY hOP
  

 0 	roundthis 	roundThis 
 
     0 n   0 numdecimals numDecimals  
 
	
 0 n  	 0 numdecimals numDecimals 0 x  
   
 $EO  *"*k"!U
   0 
createfile 
createFile     0 	afilename 	aFileName   
   0 	afilename 	aFileName 0 
thetextref 
theTextRef 0 pos   0 y   0 m   0 d   	0 today   0 mytime myTime &0 qualifiedfilename qualifiedFileName ,0 pathtothemeresources pathToThemeResources 60 qualifiedfilenamewithpath qualifiedFileNameWithPath  0 thetextfileref theTextFileRef 0 
outputtext 
outputText , !=?A
 afdrdesk
 .earsffdralis        afdr
 
TEXT
 
Krtn
 
year 0 y  
 
mnth 0 m  
 
day  0 d   
 .misccurdldt     null
 
time
 afdrcusr
 
rtyp
 
ctxt
 
psxp
 .coredoexnull     obj 
 
file
 
perm
 .rdwropenshor       file
 
set2
 .rdwrseofnull     **** 0 twolines twoLines
 
refn
 
wrat
 rdwreof 
 
as  
 
utf8
 .rdwrwritnull     ****EOj EO&EO*l E[,EZ[,EZ[,EZO%%&EO*j ,EO%%a %%a %EOa  a a a l a ,EO%j  %EO*a /a el EOa jl Oa %a %a %%a  %b  %a !%b  %b   %a "%%b  %a #%%b  %a $%_ %%EOa &a 'a (a )a * +OmvOPY hOfUOP
  0 writecontent writeContent     0 what   0 	whichfile 	whichFile    0 what   0 	whichfile 	whichFile 
 
refn
 
wrat
 rdwreof 
 
as  
 
utf8 
 .rdwrwritnull     ****  O
  &0 collectactivities collectActivities      0 
allactivities 
allActivities 

 
docu
 
RoPr
 
CAct    
 
btns
 .sysodlogaskr        TEXT .jvEO  *k/,-EUW X  kvl 	OOP
 )	
 ,0 outputattachmentlist outputAttachmentList     0 alist aList 0 aname aName 0 alevel aLevel 0 proj   0 
decoration    	  0 alist aList 0 aname aName 0 alevel aLevel 0 proj   0 
decoration   0 atext aText 0 i   0 b   0 theitem theItem 0 astatus aStatus 0 	itemnames 	itemNames 0 itemchecked itemChecked 0 c   0 temp   0 tagitems tagItems
 ?=CTd)C`p%4Ft~ 0 twolines twoLines
 
kocl
 
cobj
 .corecnte****       ****
 
Atta
 kfrmID  
 
Titl
 
msng
 
Stat    
 
RiSt
 
Chkd
 
SuTi :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue
 
AdTi
 
ChIt 0 
cellwithvalue 
cellWithValue
 
AsTo
 
FiUn
 
RiDe
 
InCh
 
Prob
 
Url 
 
Medi
 
pnam
 
StDa
 
OTag *0 convertlisttostring convertlistTostring
 
NotsZEOjv kkkh %E[OYO%%%%EOà[l kh 0EO%,%%%EO%%EOEO ,,EW X  hO a ,EW X  hO a ,EW X  hO ')a *a ,fm+ %EO)a *a ,fm+ %EUO)a fm+ %EO a -,EOa -a ,EO)a k+ %b   %a %EO Ckj kh a EO/%EO/e  a %EY hO%b   %EOP[OYOb   %EW X  hOa   : )a !a ",,fm+ %EW X  hO)a #a $,fm+ %EOPY a % Y)a &a ',fm+ %EO )a (a ),,fm+ %EW X  hO )a *a +,fm+ %EW X  hOPY a , )a -a .,fm+ %EOPY ba / ' )a 0a 1,a 2,fm+ %EW X  hY 5a 3 ,)a 4a 5,fm+ %EO)a 6a .,fm+ %EOPY hO a 5jvEO*a 7-,EOjv )a 8)a 9l+ :fm+ %EY hW X  hO*a ;,a < )a =*a ;,fm+ %EY hUOa >%%EOP[OYKY hOOP
 
 0 
withdisclamer 
withDisclamer ~~   }}  0 thetextfileref theTextFileRef   |{|  0 thetextfileref theTextFileRef{ 0 
outputtext 
outputText
 zyxwvut
z 
refn
y 
wrat
x rdwreof 
w 
as  
v 
utf8u 
t .rdwrwritnull     **** EO OhOP
 srqps :0 rowwithpropertynameandvalue rowWithPropertyNameAndValuer oo   nmln 0 	aproperty 	aPropertym 0 avalue aValuel 0 
decoration  q   kjik 0 	aproperty 	aPropertyj 0 avalue aValuei 0 
decoration   hgfe
h 
msngg 0 
cellwithvalue 
cellWithValuef 0 twolines twoLinese :0 cellwithvaluewithdecoration cellWithValueWithDecorationp @ 7f  *k+ *k+ %%Y *k+ b   %*l+ %%OPY hOP
 dcbad 0 
cellwithvalue 
cellWithValuec ``   __ 0 atext aTextb   ^^ 0 atext aText ]
] 
msnga  	%Y OP
 \"[ZY\ :0 cellwithvaluewithdecoration cellWithValueWithDecoration[ XX   WVW 0 atext aTextV 0 
decoration  Z   UTU 0 atext aTextT 0 
decoration   S;=A
S 
msngY  %%%OPY OP
 RMQPOR *0 convertlisttostring convertlistTostringQ NN   MLM 0 thelist theListL 0 thedelimiter theDelimiterP   KJIK 0 thelist theListJ 0 thedelimiter theDelimiterI 0 	thestring 	theString HGFc
H 
ascr
G 
txdl
F 
TEXTO ,FO&EO,FO
 EnDCBE >0 mapstatusconstanttostatusname mapStatusConstantToStatusNameD AA   @@ 0 aitem aItemC   ?>? 0 aitem aItem> 0 i   =<;:9
= .corecnte****       ****
< .sysolocSutxt        TEXT
; 
cobj: 	0 const  
9 
pnamB @ ;kb  j  kh j b  /,  b  /,EOY h[OYO
 87658 &0 processactivities processActivities7 4 4    323 0 
allactivities 
allActivities2  0 thetextfileref theTextFileRef6   (10/.-,+*)('&%$#"! 

1 0 
allactivities 
allActivities0  0 thetextfileref theTextFileRef/ 0 proj  . 0 projcurrency projCurrency- 0 
outputtext 
outputText, 0 act  + 0 astatus aStatus* 0 
aresources 
aResources) 0 
attacheditems 
attachedItems( 0 tagitems tagItems' "0 dependencyitems dependencyItems& 0 mytitle  % $0 aadditionaltitle aAdditionalTitle$ 0 asub aSub# 0 anote aNote" 0 alevel aLevel! 0 aorder aOrder  0 apath aPath 
0 ams aMS 0 astart aStart 0 aend aEnd 0 plannedstart plannedStart 0 
plannedend 
plannedEnd 0 	aduration 	aDuration 0 awork aWork 0 	acomplete 	aComplete 0 acost aCost 0 atitles aTitles "0 successortitles successorTitles 0 j   0 i   0 
decoration   0 aunit aUnit 	0 infos   0 evs   0 rsks  
 0 checkss   
0 filess   0 issuess  
 
0 aid aId y
	 c',BRlwBZ`jx			(	2	?	J	Y	~	


-
4
G
N
a
h
{



	 .miscactvnull  null
 
docu
 
RoPr
 
CSym
 
kocl
 
cobj
 .corecnte****       ****
 
Stat >0 mapstatusconstanttostatusname mapStatusConstantToStatusName
  
Assi
 
Reso
 
Titl
 
Atta
 
OTag
 
NeDp    
 
AdTi
 
SuTi
 
Nots 
 
OtLv
 
FlOr
 
path
 
MiSt
 
ExSt
 
ExEn
 
PlSt
 
PlEn
 
ExDu
 
ExWo
 
AcCp
 
ExCs *0 convertlisttostring convertlistTostring
 
NxAc 0 twolines twoLines
 
TmSt
 
shdt :0 rowwithpropertynameandvalue rowWithPropertyNameAndValue
 
msng d 0 	roundthis 	roundThis 0 writecontent writeContent
 
Unit
 
Amnt
 .sysolocSutxt        TEXT  
 
ID  
 
pcls
 
Info
 
Even
 
Chec
 
Risk
 
FiAt
 
Issu ,0 outputattachmentlist outputAttachmentList K
 .sysobeepnull  long 0 
withdisclamer 
withDisclamer
 .rdwrclosnull     ****5*j O*k/,EO*k/,,EOEO5[l kh ,EO)k+ 
EO#*--,EO*-EO*-,EO *a -EW X  hO*,*a ,*a ,*a ,a vE[k/EZ[l/EZ[m/EZ[a /EZO*a ,*a ,*a ,*a ,a vE[k/EZ[l/E^ Z[m/E^ Z[a /E^ ZO*a ,*a ,*a ,*a ,a vE[k/E^ Z[l/E^ Z[m/E^ Z[a /E^ ZO*a ,*a  ,lvE[k/E^ Z[l/E^ ZO*a !,*a ",lvE[k/E^ Z[l/E^ ZOPUO)a #l+ $E^ OjvE^ O 6[l kh ]   ] *a %,,%E^ W X  hU[OYO] j  a &b   %a '%%_ (%EOa )%_ (%EO)a *] a +,a ,,a -%] a +,a ,,%fm+ .%EO)a /] a +,a ,,a 0%] a +,a ,,%fm+ .%EO] a 1 ))] a 2 ll+ 3E^ O)a 4] a 5m+ .%EY hOa 1 a 6%%b   %EY hOb   %a 7%_ (%EO)l+ 8EOPY`a 9%b   %EO kkkh a :%E[OYOa ;E^ O] e  a <E^ Y hOa =%] %%_ (%EOa >%_ (%EO)a ?fm+ .%EO)a @fm+ .%EO)a A] fm+ .%EO] e  )a Ba Cfm+ .%EY hO)a D] a +,a ,,a E%] a +,a ,,%fm+ .%EO] a 1 Z] a F,E^  O] a 1 M)a G)] a H,ll+ 3a I%] a F,j J%a K%)] a H,ll+ 3%a L%]  j J%fm+ .%EY ()a M)] a H,ll+ 3a N%]  j J%fm+ .%EY hO)a O] m+ .%EO] a 1 ))] a 2 ll+ 3E^ O)a P] a Qm+ .%EY hO)a Rfm+ .%EO] jv )a S)] a Tl+ $fm+ .%EY hO %] a U )a V] fm+ .%EY hOPW X  hOjv )a W)a Xl+ $fm+ .%EY hOa Y )a Zfm+ .%EY hOa [%_ (%EOPOjv. kkkh a \%E[OYOa ]%b   %b   %EOjvjvjvjvjvjva ^vE[k/E^ !Z[l/E^ "Z[m/E^ #Z[a /E^ $Z[a _/E^ %Z[a ^/E^ &ZO Ө[l kh ] a `,E^ 'O] a a,a b  ] !] '%E^ !Y hO] a a,a c  ] "] '%E^ "Y hO] a a,a d  ] $] '%E^ $Y hO] a a,a e  ] #] '%E^ #Y hO] a a,a f  ] %] '%E^ %Y hO] a a,a g  ] &] '%E^ &Y h[OY;O] !jv )] !a ha ia _+ j%EY hO] "jv )] "a ka la _+ j%EY hO] %jv )] %a ma na _+ j%EY hO] $jv )] $a oa pa _+ j%EY hO] &jv )] &a qa ra _+ j%EY hO] #jv )] #a sa ta _+ j%EY hOPY hO] a u#j  )l+ 8EO*j vY h[OYO)l+ 8EO)k+ wO*j vO 
j xW X  hUOP
 !!  
 

 " "  #$%&'# (( )*) +,+ -
 
docu- .. , S i m p l e   M i l e s t o n e   B a s i s
 
Prjc, // , n 3 k d q 3 6 F R _ W Z x d A 7 p - N q N g
 kfrmID  
 
Acty* 00 , b n R F o n K L T J O d _ q 3 m T j t F w w
 kfrmID  $ 11 232 454 6
 
docu6 77 , S i m p l e   M i l e s t o n e   B a s i s
 
Prjc5 88 , n 3 k d q 3 6 F R _ W Z x d A 7 p - N q N g
 kfrmID  
 
Acty3 99 , 6 I D c 2 8 k w T _ - m l s - R L 2 Y 4 P w
 kfrmID  % :: ;<; =>= ?
 
docu? @@ , S i m p l e   M i l e s t o n e   B a s i s
 
Prjc> AA , n 3 k d q 3 6 F R _ W Z x d A 7 p - N q N g
 kfrmID  
 
Acty< BB , r Z 6 U b c 5 Z R G - m f h b A M O p X 4 Q
 kfrmID  & CC DED FGF H
 
docuH II , S i m p l e   M i l e s t o n e   B a s i s
 
PrjcG JJ , n 3 k d q 3 6 F R _ W Z x d A 7 p - N q N g
 kfrmID  
 
ActyE KK , E X i 9 S H W t T B m w W g a Z v f n 8 G Q
 kfrmID  ' LL MNM OPO Q
 
docuQ RR , S i m p l e   M i l e s t o n e   B a s i s
 
PrjcP SS , n 3 k d q 3 6 F R _ W Z x d A 7 p - N q N g
 kfrmID  
 
ActyN TT , 8 _ 1 R F Q y g R r a p 2 h I r f Q j 2 7 A
 kfrmID  i K
 UU B M a c i n t o s h   H D : U s e r s : v i c k y : D e s k t o p :
 VV \ J a n u a r y   2 0 2 3 - 4 8 8 2 3 - S i m p l e   M i l e s t o n e   B a s i s . a d o ch  g  f  e  d  c  b  a  `  _  ^  ]  \  [  ascr  ޭ